/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker;

import LegendaryCardMaker.CampaignManager.CampaignManagerFrame;
import LegendaryCardMaker.CardMaker;
import LegendaryCardMaker.CardTextDialog;
import LegendaryCardMaker.CustomCardMaker.gui.CustomTemplateList;
import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryDividerMaker.HeroDividerMakerFrame;
import LegendaryCardMaker.LegendaryDividerMaker.VillainDividerMakerFrame;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryHeroMaker.HeroMaker;
import LegendaryCardMaker.LegendaryHeroMaker.HeroMakerFrame;
import LegendaryCardMaker.LegendaryHeroMaker.HeroSelectorMenu;
import LegendaryCardMaker.LegendaryItem;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCard;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeMaker;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeSelectorMenu;
import LegendaryCardMaker.LegendaryVillainMaker.BindingsSelectorMenu;
import LegendaryCardMaker.LegendaryVillainMaker.BystanderSelectorMenu;
import LegendaryCardMaker.LegendaryVillainMaker.Villain;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCard;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCardType;
import LegendaryCardMaker.LegendaryVillainMaker.VillainMaker;
import LegendaryCardMaker.LegendaryVillainMaker.VillainSelectorMenu;
import LegendaryCardMaker.LegendaryVillainMaker.WoundSelectorMenu;
import LegendaryCardMaker.SchemeTypeSelectorMenu;
import LegendaryCardMaker.TeamIconSelectorMenu;
import LegendaryCardMaker.TextOutputDialog;
import LegendaryCardMaker.exporters.ExportDividersHomeprintProgressBarDialog;
import LegendaryCardMaker.exporters.ExportFullProgressBarDialog;
import LegendaryCardMaker.exporters.ExportHomeprintProgressBarDialog;
import LegendaryCardMaker.exporters.ExportProgressBarDialog;
import LegendaryCardMaker.exporters.ItemSelectorDialog;
import LegendaryCardMaker.tools.bleeder.LegeditBleeder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CardMakerToolbar
extends JMenuBar
implements ActionListener {
    private Locale currentLocale = Locale.getDefault();
    private ResourceBundle labels = ResourceBundle.getBundle("LegendaryCardMaker.tools.language.LegendaryCardMakerMenu", this.currentLocale);
    JMenu file = new JMenu("File");
    JMenuItem newExpansion = new JMenuItem("New");
    JMenuItem open = new JMenuItem("Open...");
    JMenuItem save = new JMenuItem("Save");
    JMenuItem saveAs = new JMenuItem("SaveAs...");
    JMenuItem exit = new JMenuItem("Exit");
    JMenuItem exportJPG = new JMenuItem("Export_to_JPEG...");
    JMenuItem exportPNG = new JMenuItem("Export_to_PNG...");
    JMenuItem exportPrinterStudioPNG = new JMenuItem("Export_to_Printer_Studio_PNG...");
    JMenuItem exportJPEGHomeprint = new JMenuItem("Export_to_JPEG_for_Homeprint...");
    JMenuItem exportSelectedJPEGHomeprint = new JMenuItem("Export_Selected_Items_to_JPEG_for_Homeprint...");
    JMenuItem exportDividersJPEGHomeprint = new JMenuItem("Export_Dividers_to_JPEG_for_Homeprint...");
    JMenuItem exportFull = new JMenuItem("Export_Full_Expansion...");
    JMenuItem viewAsText = new JMenuItem("View_as_Text...");
    JMenuItem viewStatistics = new JMenuItem("View_Statistics...");
    HeroSelectorMenu heroSelectorMenu = null;
    VillainSelectorMenu villainSelectorMenu = null;
    SchemeSelectorMenu schemeSelectorMenu = null;
    TeamIconSelectorMenu teamSelectorMenu = null;
    BystanderSelectorMenu bystanderSelectorMenu = null;
    WoundSelectorMenu woundSelectorMenu = null;
    BindingsSelectorMenu bindingsSelectorMenu = null;
    SchemeTypeSelectorMenu schemeTypeSelectorMenu = null;
    JMenu editMenu = new JMenu("Edit");
    JMenu divider = new JMenu("Templates");
    JMenu orientation = new JMenu("Divider_Orientation");
    JCheckBoxMenuItem orientationHorizontal = new JCheckBoxMenuItem("Horizontal");
    JCheckBoxMenuItem orientationVertical = new JCheckBoxMenuItem("Vertical");
    JMenuItem editHeroDividerTemplate = new JMenuItem("Edit_Hero_Divider_Template...");
    JMenuItem editVillainDividerTemplate = new JMenuItem("Edit_Villain_Divider_Template...");
    JMenuItem editHeroTemplate = new JMenuItem("Edit_Hero_Template...");
    JMenu expansion = new JMenu("Expansion");
    JMenu style = new JMenu("Style");
    List<JCheckBoxMenuItem> styleItems = new ArrayList<JCheckBoxMenuItem>();
    JMenuItem expansionName = new JMenuItem("Expansion_Name...");
    JMenuItem rules = new JMenuItem("Edit_Rules...");
    JMenuItem keywords = new JMenuItem("Edit_Keywords...");
    JMenu tools = new JMenu("Tools");
    JMenuItem campaignManager = new JMenuItem("Campaign_Manager...");
    JMenuItem bleeder = new JMenuItem("Bleeder...");
    JMenu language = new JMenu("Language");
    JMenuItem UKLang = new JMenuItem("English");
    JMenuItem DELang = new JMenuItem("German");
    JMenuItem FRLang = new JMenuItem("French");
    JMenu help = new JMenu("Help");
    LegendaryCardMakerFrame lcmf;
    static CardMakerToolbar tb = null;

    public void setLanguage() {
        this.file.setText(this.labels.getString("File"));
        this.newExpansion.setText(this.labels.getString("New"));
        this.open.setText(this.labels.getString("Open"));
        this.save.setText(this.labels.getString("Save"));
        this.saveAs.setText(this.labels.getString("SaveAs"));
        this.exit.setText(this.labels.getString("Exit"));
        this.exportJPG.setText(this.labels.getString("ExporttoJPEG"));
        this.exportPNG.setText(this.labels.getString("ExporttoPNG"));
        this.exportPrinterStudioPNG.setText(this.labels.getString("ExporttoPrinterStudioPNG"));
        this.exportJPEGHomeprint.setText(this.labels.getString("ExporttoJPEGforHomeprint"));
        this.exportSelectedJPEGHomeprint.setText(this.labels.getString("ExportSelectedItemstoJPEGforHomeprint"));
        this.exportDividersJPEGHomeprint.setText(this.labels.getString("ExportDividerstoJPEGforHomeprint"));
        this.exportFull.setText(this.labels.getString("ExportFullExpansion"));
        this.viewAsText.setText(this.labels.getString("ViewasText"));
        this.viewStatistics.setText(this.labels.getString("ViewStatistics"));
        this.editMenu.setText(this.labels.getString("Edit"));
        this.divider.setText(this.labels.getString("Templates"));
        this.orientation.setText(this.labels.getString("DividerOrientation"));
        this.orientationHorizontal.setText(this.labels.getString("Horizontal"));
        this.orientationVertical.setText(this.labels.getString("Vertical"));
        this.editHeroDividerTemplate.setText(this.labels.getString("EditHeroDividerTemplate"));
        this.editVillainDividerTemplate.setText(this.labels.getString("EditVillainDividerTemplate"));
        this.editHeroTemplate.setText(this.labels.getString("EditHeroTemplate"));
        this.expansion.setText(this.labels.getString("Expansion"));
        this.style.setText(this.labels.getString("Style"));
        this.expansionName.setText(this.labels.getString("ExpansionName"));
        this.rules.setText(this.labels.getString("EditRules"));
        this.keywords.setText(this.labels.getString("EditKeywords"));
        this.tools.setText(this.labels.getString("Tools"));
        this.campaignManager.setText(this.labels.getString("CampaignManager"));
        this.bleeder.setText(this.labels.getString("Bleeder"));
        this.help.setText(this.labels.getString("Help"));
        this.language.setText(this.labels.getString("Language"));
        this.UKLang.setText(this.labels.getString("English"));
        this.DELang.setText(this.labels.getString("German"));
        this.FRLang.setText(this.labels.getString("French"));
    }

    public CardMakerToolbar(LegendaryCardMakerFrame lcmf) {
        this.setLanguage();
        tb = this;
        this.lcmf = lcmf;
        this.newExpansion.addActionListener(this);
        this.file.add(this.newExpansion);
        this.file.addSeparator();
        this.open.addActionListener(this);
        this.file.add(this.open);
        this.file.addSeparator();
        this.save.addActionListener(this);
        this.file.add(this.save);
        this.saveAs.addActionListener(this);
        this.file.add(this.saveAs);
        this.file.addSeparator();
        this.exportPNG.addActionListener(this);
        this.file.add(this.exportPNG);
        this.exportJPG.addActionListener(this);
        this.file.add(this.exportJPG);
        this.exportJPEGHomeprint.addActionListener(this);
        this.file.add(this.exportJPEGHomeprint);
        this.exportSelectedJPEGHomeprint.addActionListener(this);
        this.file.add(this.exportSelectedJPEGHomeprint);
        this.file.addSeparator();
        this.exportDividersJPEGHomeprint.addActionListener(this);
        this.file.add(this.exportDividersJPEGHomeprint);
        this.file.addSeparator();
        this.exportFull.addActionListener(this);
        this.file.add(this.exportFull);
        this.file.addSeparator();
        this.viewAsText.addActionListener(this);
        this.file.add(this.viewAsText);
        this.viewStatistics.addActionListener(this);
        this.file.add(this.viewStatistics);
        this.file.addSeparator();
        this.exit.addActionListener(this);
        this.file.add(this.exit);
        this.add(this.file);
        this.add(this.editMenu);
        this.heroSelectorMenu = new HeroSelectorMenu(lcmf, tb);
        this.villainSelectorMenu = new VillainSelectorMenu(lcmf, tb);
        this.schemeSelectorMenu = new SchemeSelectorMenu(lcmf, tb);
        this.teamSelectorMenu = new TeamIconSelectorMenu(lcmf, tb);
        this.bystanderSelectorMenu = new BystanderSelectorMenu(lcmf, tb);
        this.woundSelectorMenu = new WoundSelectorMenu(lcmf, tb);
        this.bindingsSelectorMenu = new BindingsSelectorMenu(lcmf, tb);
        this.schemeTypeSelectorMenu = new SchemeTypeSelectorMenu(lcmf, tb);
        this.setEditMenu();
        this.editHeroTemplate.addActionListener(this);
        this.divider.add(this.editHeroTemplate);
        this.divider.addSeparator();
        this.orientationHorizontal.addActionListener(this);
        this.orientationHorizontal.setSelected(LegendaryCardMakerFrame.lcmf.lcm.dividerHorizontal);
        this.orientation.add(this.orientationHorizontal);
        this.orientationVertical.addActionListener(this);
        this.orientationVertical.setSelected(!LegendaryCardMakerFrame.lcmf.lcm.dividerHorizontal);
        this.orientation.add(this.orientationVertical);
        this.divider.add(this.orientation);
        this.editHeroDividerTemplate.addActionListener(this);
        this.divider.add(this.editHeroDividerTemplate);
        this.editVillainDividerTemplate.addActionListener(this);
        this.divider.add(this.editVillainDividerTemplate);
        this.add(this.divider);
        this.expansionName.addActionListener(this);
        this.expansion.add(this.expansionName);
        this.rules.addActionListener(this);
        this.expansion.add(this.rules);
        this.keywords.addActionListener(this);
        this.expansion.add(this.keywords);
        this.add(this.expansion);
        this.bleeder.addActionListener(this);
        this.tools.add(this.bleeder);
        this.add(this.tools);
        JMenuItem version = new JMenuItem("Version: " + LegendaryCardMaker.version);
        version.setEnabled(false);
        this.help.add(version);
        this.add(this.help);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        ItemSelectorDialog selector;
        List<CardMaker> makers;
        JFileChooser chooser;
        int outcome;
        this.setLanguage();
        if (e.getSource().equals(this.open) && (outcome = (chooser = new JFileChooser(this.lcmf.lcm.lastOpened)).showOpenDialog(this)) == 0) {
            HeroMaker.resetTemplateValues();
            this.lcmf.lcm.processInput(chooser.getSelectedFile().getAbsolutePath());
            this.lcmf.setTitle("Legendedit - " + chooser.getSelectedFile().getName());
            this.lcmf.heroListModel.removeAllElements();
            for (Hero hero : this.lcmf.lcm.heroes) {
                this.lcmf.heroListModel.addElement(hero);
            }
            this.lcmf.villainListModel.removeAllElements();
            for (Villain villain : this.lcmf.lcm.villains) {
                if (villain.name.equals("system_bystander_villain") || villain.name.equals("system_wound_villain")) continue;
                this.lcmf.villainListModel.addElement(villain);
            }
            this.lcmf.schemeListModel.removeAllElements();
            for (SchemeCard schemeCard : this.lcmf.lcm.schemes) {
                this.lcmf.schemeListModel.addElement(schemeCard);
            }
            this.lcmf.bystanderListModel.removeAllElements();
            Collections.sort(this.lcmf.lcm.villains, new Villain());
            for (Villain villain : this.lcmf.lcm.villains) {
                for (VillainCard villainCard : villain.cards) {
                    if (villainCard.cardType == null || !villainCard.cardType.equals((Object)VillainCardType.BYSTANDER)) continue;
                    this.lcmf.bystanderListModel.addElement(villainCard);
                }
            }
            this.lcmf.woundListModel.removeAllElements();
            Collections.sort(this.lcmf.lcm.villains, new Villain());
            for (Villain villain : this.lcmf.lcm.villains) {
                for (VillainCard villainCard : villain.cards) {
                    if (villainCard.cardType == null || !villainCard.cardType.equals((Object)VillainCardType.WOUND)) continue;
                    this.lcmf.woundListModel.addElement(villainCard);
                }
            }
            Set<Map.Entry<String, CustomTemplateList>> set = this.lcmf.customTemplateListSet.entrySet();
            for (Map.Entry<String, CustomTemplateList> entry : set) {
                entry.getValue().cardListModel.removeAllElements();
                Collections.sort(this.lcmf.lcm.customCards, new CustomCard());
                entry.getValue().loadList(this.lcmf.lcm.customCards);
            }
            this.lcmf.applicationProps.put("lastExpansion", chooser.getSelectedFile().getAbsolutePath());
            this.lcmf.applicationProps.put("lastOpenDirectory", chooser.getSelectedFile().getParent());
            this.lcmf.lcm.lastOpened = chooser.getSelectedFile().getParent();
            this.lcmf.saveProperties();
        }
        if (e.getSource().equals(this.save)) {
            if (this.lcmf.lcm.currentFile != null && new File(this.lcmf.lcm.currentFile).exists()) {
                try {
                    this.lcmf.lcm.saveExpansion();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + ex.getMessage());
                }
            } else {
                chooser = new JFileChooser(this.lcmf.lcm.lastSaved);
                outcome = chooser.showSaveDialog(this);
                if (outcome == 0) {
                    this.lcmf.lcm.currentFile = chooser.getSelectedFile().getAbsolutePath();
                    try {
                        this.lcmf.lcm.saveExpansion();
                        this.lcmf.applicationProps.put("lastExpansion", chooser.getSelectedFile().getAbsolutePath());
                        this.lcmf.applicationProps.put("lastSaveDirectory", chooser.getSelectedFile().getParent());
                        this.lcmf.lcm.lastSaved = chooser.getSelectedFile().getParent();
                        this.lcmf.saveProperties();
                        this.lcmf.setTitle("Legendedit - " + chooser.getSelectedFile().getName());
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + exception.getMessage());
                    }
                }
            }
        }
        if (e.getSource().equals(this.saveAs) && (outcome = (chooser = new JFileChooser(this.lcmf.lcm.lastSaved)).showSaveDialog(this)) == 0) {
            this.lcmf.lcm.currentFile = chooser.getSelectedFile().getAbsolutePath();
            try {
                this.lcmf.lcm.saveExpansion();
                this.lcmf.applicationProps.put("lastExpansion", chooser.getSelectedFile().getAbsolutePath());
                this.lcmf.applicationProps.put("lastSaveDirectory", chooser.getSelectedFile().getParent());
                this.lcmf.lcm.lastSaved = chooser.getSelectedFile().getParent();
                this.lcmf.saveProperties();
                this.lcmf.setTitle("Legendedit - " + chooser.getSelectedFile().getName());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + exception.getMessage());
            }
        }
        if (e.getSource().equals(this.exit)) {
            int outcome2;
            if (this.lcmf.lcm.doChangesExist() && (outcome2 = JOptionPane.showOptionDialog(this.lcmf, String.valueOf(this.labels.getString("SaveChanges")) + "?", this.labels.getString("SaveChanges"), 0, 3, null, null, null)) == 0) {
                if (this.lcmf.lcm.currentFile != null && new File(this.lcmf.lcm.currentFile).exists()) {
                    try {
                        this.lcmf.lcm.saveExpansion();
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + ex.getMessage());
                    }
                } else {
                    JFileChooser chooser2 = new JFileChooser();
                    int n = chooser2.showSaveDialog(this);
                    if (n == 0) {
                        this.lcmf.lcm.currentFile = chooser2.getSelectedFile().getAbsolutePath();
                        try {
                            this.lcmf.lcm.saveExpansion();
                            this.lcmf.applicationProps.put("lastSaveDirectory", chooser2.getSelectedFile().getParent());
                            this.lcmf.lcm.lastSaved = chooser2.getSelectedFile().getParent();
                            this.lcmf.saveProperties();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + exception.getMessage());
                        }
                    }
                }
            }
            System.exit(0);
        }
        if (e.getSource().equals(this.newExpansion)) {
            int outcome3;
            if (this.lcmf.lcm.doChangesExist() && (outcome3 = JOptionPane.showOptionDialog(this.lcmf, String.valueOf(this.labels.getString("SaveChanges")) + "?", this.labels.getString("SaveChanges"), 0, 3, null, null, null)) == 0) {
                if (this.lcmf.lcm.currentFile != null && new File(this.lcmf.lcm.currentFile).exists()) {
                    try {
                        this.lcmf.lcm.saveExpansion();
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + ex.getMessage());
                    }
                } else {
                    JFileChooser chooser3 = new JFileChooser(this.lcmf.lcm.lastSaved);
                    int n = chooser3.showSaveDialog(this);
                    if (n == 0) {
                        this.lcmf.lcm.currentFile = chooser3.getSelectedFile().getAbsolutePath();
                        try {
                            this.lcmf.lcm.saveExpansion();
                            this.lcmf.applicationProps.put("lastSaveDirectory", chooser3.getSelectedFile().getParent());
                            this.lcmf.lcm.lastSaved = chooser3.getSelectedFile().getParent();
                            this.lcmf.saveProperties();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + exception.getMessage());
                        }
                    }
                }
            }
            this.lcmf.createNewExpansion();
            HeroMaker.resetTemplateValues();
        }
        if (e.getSource().equals(this.exportPNG)) {
            chooser = new JFileChooser();
            if (this.lcmf.lcm.exportFolder != null) {
                File tf = new File(this.lcmf.lcm.exportFolder);
                chooser = new JFileChooser(tf.getParent());
            }
            chooser.setFileSelectionMode(1);
            outcome = chooser.showSaveDialog(this);
            if (outcome == 0) {
                File file = chooser.getSelectedFile();
                this.lcmf.lcm.exportFolder = file.getAbsolutePath();
                file.mkdirs();
                try {
                    this.lcmf.applicationProps.put("lastExportDirectory", chooser.getSelectedFile().getAbsolutePath());
                    ExportProgressBarDialog exportProgressBarDialog = new ExportProgressBarDialog(this.lcmf.lcm.getCardCount(), this.lcmf.lcm, file);
                    exportProgressBarDialog.createAndShowGUI();
                    this.lcmf.saveProperties();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + exception.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.exportJPG)) {
            chooser = new JFileChooser();
            if (this.lcmf.lcm.exportFolder != null) {
                File tf = new File(this.lcmf.lcm.exportFolder);
                chooser = new JFileChooser(tf.getParent());
            }
            chooser.setFileSelectionMode(1);
            outcome = chooser.showSaveDialog(this);
            if (outcome == 0) {
                File file = chooser.getSelectedFile();
                this.lcmf.lcm.exportFolder = file.getAbsolutePath();
                file.mkdirs();
                try {
                    this.lcmf.applicationProps.put("lastExportDirectory", chooser.getSelectedFile().getAbsolutePath());
                    ExportProgressBarDialog exportProgressBarDialog = new ExportProgressBarDialog(this.lcmf.lcm.getCardCount(), this.lcmf.lcm, file);
                    exportProgressBarDialog.setJpegMode(true);
                    exportProgressBarDialog.createAndShowGUI();
                    this.lcmf.saveProperties();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + exception.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.exportJPEGHomeprint)) {
            chooser = new JFileChooser();
            if (this.lcmf.lcm.exportFolder != null) {
                File tf = new File(this.lcmf.lcm.exportFolder);
                chooser = new JFileChooser(tf.getParent());
            }
            chooser.setFileSelectionMode(1);
            outcome = chooser.showSaveDialog(this);
            if (outcome == 0) {
                File file = chooser.getSelectedFile();
                this.lcmf.lcm.exportFolder = file.getAbsolutePath();
                file.mkdirs();
                try {
                    this.lcmf.applicationProps.put("lastExportDirectory", chooser.getSelectedFile().getAbsolutePath());
                    ExportHomeprintProgressBarDialog exportHomeprintProgressBarDialog = new ExportHomeprintProgressBarDialog(this.lcmf.lcm.getCardCount(), this.lcmf.lcm, file, null);
                    exportHomeprintProgressBarDialog.createAndShowGUI();
                    this.lcmf.saveProperties();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + exception.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.exportDividersJPEGHomeprint)) {
            chooser = new JFileChooser();
            if (this.lcmf.lcm.exportFolder != null) {
                File tf = new File(this.lcmf.lcm.exportFolder);
                chooser = new JFileChooser(tf.getParent());
            }
            chooser.setFileSelectionMode(1);
            outcome = chooser.showSaveDialog(this);
            if (outcome == 0) {
                File file = chooser.getSelectedFile();
                this.lcmf.lcm.exportFolder = file.getAbsolutePath();
                file.mkdirs();
                try {
                    this.lcmf.applicationProps.put("lastExportDirectory", chooser.getSelectedFile().getAbsolutePath());
                    ExportDividersHomeprintProgressBarDialog exportDividersHomeprintProgressBarDialog = new ExportDividersHomeprintProgressBarDialog(this.lcmf.lcm.getCardCount(), this.lcmf.lcm, file);
                    exportDividersHomeprintProgressBarDialog.createAndShowGUI();
                    this.lcmf.saveProperties();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + exception.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.viewAsText)) {
            String str = "";
            str = String.valueOf(str) + "KEYWORDS\n\n";
            str = String.valueOf(str) + this.lcmf.lcm.keywords.replace("<k>", "").replace("<r>", "").replace(" <g> ", "\n");
            str = String.valueOf(str) + "\n\n\n";
            str = String.valueOf(str) + "HEROES\n\n";
            for (Hero h : this.lcmf.lcm.heroes) {
                str = String.valueOf(str) + h.name + "\n\n";
                for (HeroCard heroCard : h.cards) {
                    str = String.valueOf(str) + heroCard.getTextExportString() + "\n\n";
                }
                str = String.valueOf(str) + "\n";
            }
            str = String.valueOf(str) + "VILLAINS\n\n";
            for (Villain v : this.lcmf.lcm.villains) {
                str = v.name.equals("system_bystander_villain") ? String.valueOf(str) + "BYSTANDERS\n\n" : (v.name.equals("system_wound_villain") ? String.valueOf(str) + "WOUNDS\n\n" : (v.name.equals("system_bindings_villain") ? String.valueOf(str) + "BINDINGS\n\n" : String.valueOf(str) + v.name + "\n\n"));
                for (VillainCard villainCard : v.cards) {
                    str = String.valueOf(str) + villainCard.getTextExportString() + "\n";
                }
                str = String.valueOf(str) + "\n";
            }
            str = String.valueOf(str) + "SCHEMES\n\n";
            for (SchemeCard s : this.lcmf.lcm.schemes) {
                str = String.valueOf(str) + s.getTextExportString() + "\n";
                str = String.valueOf(str) + "\n";
            }
            TextOutputDialog dialog = new TextOutputDialog(str);
            dialog.setVisible(true);
        }
        if (e.getSource().equals(this.viewStatistics)) {
            String str = this.analyseExpansion();
            TextOutputDialog dialog = new TextOutputDialog(str);
            dialog.setVisible(true);
        }
        if (e.getSource().equals(this.editHeroDividerTemplate)) {
            HeroDividerMakerFrame str = new HeroDividerMakerFrame(null, this.lcmf.lcm.dividerHorizontal);
        }
        if (e.getSource().equals(this.editVillainDividerTemplate)) {
            VillainDividerMakerFrame str = new VillainDividerMakerFrame(null, this.lcmf.lcm.dividerHorizontal);
        }
        if (e.getSource().equals(this.editHeroTemplate)) {
            HeroMakerFrame str = new HeroMakerFrame(null);
        }
        if (e.getSource().equals(this.orientationHorizontal)) {
            this.orientationHorizontal.setSelected(true);
            this.orientationVertical.setSelected(false);
            LegendaryCardMakerFrame.lcmf.lcm.dividerHorizontal = true;
        }
        if (e.getSource().equals(this.orientationVertical)) {
            this.orientationHorizontal.setSelected(false);
            this.orientationVertical.setSelected(true);
            LegendaryCardMakerFrame.lcmf.lcm.dividerHorizontal = false;
        }
        if (e.getSource().equals(this.campaignManager)) {
            new CampaignManagerFrame();
        }
        if (e.getSource().equals(this.exportFull)) {
            chooser = new JFileChooser();
            FileNameExtensionFilter filter1 = new FileNameExtensionFilter("ZIP file", "zip");
            chooser.addChoosableFileFilter(filter1);
            chooser.setFileFilter(filter1);
            if (this.lcmf.lcm.exportFolder != null) {
                File file = new File(this.lcmf.lcm.exportFolder);
                chooser = new JFileChooser(file);
            }
            chooser.setFileSelectionMode(0);
            int n = chooser.showSaveDialog(this);
            if (n == 0) {
                File file = chooser.getSelectedFile();
                try {
                    ExportFullProgressBarDialog exportFullProgressBarDialog = new ExportFullProgressBarDialog(this.lcmf.lcm.getCardCount(), this.lcmf.lcm, file);
                    exportFullProgressBarDialog.createAndShowGUI();
                    this.lcmf.saveProperties();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + exception.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.exportSelectedJPEGHomeprint) && (makers = this.legendaryItemToCardMaker((selector = new ItemSelectorDialog(this.lcmf)).getLegendaryItems())).size() > 0) {
            void var4_99;
            JFileChooser jFileChooser = new JFileChooser();
            if (this.lcmf.lcm.exportFolder != null) {
                File file = new File(this.lcmf.lcm.exportFolder);
                JFileChooser jFileChooser2 = new JFileChooser(file.getParent());
            }
            var4_99.setFileSelectionMode(1);
            int n = var4_99.showSaveDialog(this);
            if (n == 0) {
                File file = var4_99.getSelectedFile();
                this.lcmf.lcm.exportFolder = file.getAbsolutePath();
                file.mkdirs();
                try {
                    this.lcmf.applicationProps.put("lastExportDirectory", var4_99.getSelectedFile().getAbsolutePath());
                    ExportHomeprintProgressBarDialog exporter3 = new ExportHomeprintProgressBarDialog(this.lcmf.lcm.getCardCount(), this.lcmf.lcm, file, makers);
                    exporter3.createAndShowGUI();
                    this.lcmf.saveProperties();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.lcmf, String.valueOf(this.labels.getString("Error")) + "! " + ex.getMessage());
                }
            }
        }
        if (e.getSource().equals(this.keywords)) {
            String s = new CardTextDialog(this.lcmf.lcm.keywords).showInputDialog();
            if (s == null) {
                s = this.lcmf.lcm.keywords;
            }
            if (s != null && s.isEmpty()) {
                s = null;
            }
            this.lcmf.lcm.keywords = s;
        }
        if (e.getSource().equals(this.rules)) {
            String s = new CardTextDialog(this.lcmf.lcm.rules).showInputDialog();
            if (s == null) {
                s = this.lcmf.lcm.rules;
            }
            if (s != null && s.isEmpty()) {
                s = null;
            }
            this.lcmf.lcm.rules = s;
        }
        if (e.getSource().equals(this.expansionName)) {
            String s = JOptionPane.showInputDialog(this.lcmf, "Enter the Expansion Name", this.lcmf.lcm.expansionName);
            if (s == null) {
                s = this.lcmf.lcm.expansionName;
            }
            if (s != null && s.isEmpty()) {
                s = null;
            }
            this.lcmf.lcm.expansionName = s;
        }
        if (e.getSource().equals(this.bleeder)) {
            new LegeditBleeder();
        }
    }

    public String analyseExpansion() {
        String str = "";
        int totalNumberOfCards = 0;
        int totalNumberOfUniqueCards = 0;
        int totalNumberOfHeroCards = 0;
        HashMap<Object, Integer> cardRarityHash = new HashMap<Object, Integer>();
        HashMap<Object, Integer> teamHash = new HashMap<Object, Integer>();
        HashMap<Object, Integer> powerHash = new HashMap<Object, Integer>();
        HashMap<Object, Integer> triggerHash = new HashMap<Object, Integer>();
        int totalBaseAttack = 0;
        int totalAttackCards = 0;
        HashMap<Object, Integer> baseAttackHash = new HashMap<Object, Integer>();
        int totalBaseRecruit = 0;
        int totalRecruitCards = 0;
        HashMap<Object, Integer> baseRecruitHash = new HashMap<Object, Integer>();
        int totalBaseCost = 0;
        int totalCostCards = 0;
        HashMap<Object, Integer> baseCostHash = new HashMap<Object, Integer>();
        for (Hero h : this.lcmf.lcm.heroes) {
            for (HeroCard heroCard : h.cards) {
                Integer baseCost;
                Integer baseRecruit;
                totalNumberOfCards += heroCard.rarity.getCount();
                ++totalNumberOfUniqueCards;
                totalNumberOfHeroCards += heroCard.rarity.getCount();
                this.updateCount(cardRarityHash, (Object)heroCard.rarity, heroCard.rarity.getCount());
                this.updateCount(teamHash, heroCard.cardTeam, heroCard.rarity.getCount());
                this.updateCount(powerHash, heroCard.cardPower, heroCard.rarity.getCount());
                for (String tr : heroCard.getTriggers()) {
                    this.updateCount(triggerHash, tr, heroCard.rarity.getCount());
                }
                Integer baseAttack = heroCard.getBaseAttack();
                if (baseAttack != null) {
                    if (baseAttack > 0) {
                        totalAttackCards += heroCard.rarity.getCount();
                    }
                    totalBaseAttack += heroCard.getBaseAttack() * heroCard.rarity.getCount();
                    this.updateCount(baseAttackHash, heroCard.getBaseAttack(), heroCard.rarity.getCount());
                }
                if ((baseRecruit = heroCard.getBaseRecruit()) != null) {
                    if (baseRecruit > 0) {
                        totalRecruitCards += heroCard.rarity.getCount();
                    }
                    totalBaseRecruit += heroCard.getBaseRecruit() * heroCard.rarity.getCount();
                    this.updateCount(baseRecruitHash, heroCard.getBaseRecruit(), heroCard.rarity.getCount());
                }
                if ((baseCost = heroCard.getBaseCost()) == null) continue;
                if (baseCost > 0) {
                    totalCostCards += heroCard.rarity.getCount();
                }
                totalBaseCost += heroCard.getBaseCost() * heroCard.rarity.getCount();
                this.updateCount(baseCostHash, heroCard.getBaseCost(), heroCard.rarity.getCount());
            }
        }
        for (Villain v : this.lcmf.lcm.villains) {
            for (VillainCard villainCard : v.cards) {
                totalNumberOfCards += villainCard.cardType.getCount();
                ++totalNumberOfUniqueCards;
            }
        }
        for (SchemeCard s : this.lcmf.lcm.schemes) {
            ++totalNumberOfUniqueCards;
        }
        DecimalFormat f = new DecimalFormat("##.##");
        str = String.valueOf(str) + "Number of Unique Cards: " + totalNumberOfUniqueCards + "\n";
        str = String.valueOf(str) + "Number of Cards: " + totalNumberOfCards + "\n";
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "**************************\n";
        str = String.valueOf(str) + "Heroes\n";
        str = String.valueOf(str) + "**************************\n";
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Number of Heroes: " + this.lcmf.lcm.heroes.size() + "\n";
        str = String.valueOf(str) + "Number of Hero Cards: " + totalNumberOfHeroCards + "\n";
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Card Rarity Counts:\n";
        str = String.valueOf(str) + this.printHash(cardRarityHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Team Counts:\n";
        str = String.valueOf(str) + this.printHash(teamHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Power Counts:\n";
        str = String.valueOf(str) + this.printHash(powerHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Trigger Counts:\n";
        str = String.valueOf(str) + this.printHash(triggerHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Total Base Attack: " + totalBaseAttack + "\n";
        str = String.valueOf(str) + "Average Base Attack Per Card (Including 0 Attack): " + f.format((double)totalBaseAttack / (double)totalNumberOfCards) + "\n";
        str = String.valueOf(str) + "Average Base Attack Per Card (Not Including 0 Attack): " + f.format((double)totalBaseAttack / (double)totalAttackCards) + "\n";
        str = String.valueOf(str) + "Cards by Base Attack:\n";
        str = String.valueOf(str) + this.printHash(baseAttackHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Total Base Recruit: " + totalBaseRecruit + "\n";
        str = String.valueOf(str) + "Average Base Recruit Per Card (Including 0 Recruit): " + f.format((double)totalBaseRecruit / (double)totalNumberOfCards) + "\n";
        str = String.valueOf(str) + "Average Base Recruit Per Card (Not Including 0 Recruit): " + f.format((double)totalBaseRecruit / (double)totalRecruitCards) + "\n";
        str = String.valueOf(str) + "Cards by Base Recruit:\n";
        str = String.valueOf(str) + this.printHash(baseRecruitHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Total Base Cost: " + totalBaseCost + "\n";
        str = String.valueOf(str) + "Average Base Cost Per Card (Including 0 Cost): " + f.format((double)totalBaseCost / (double)totalNumberOfCards) + "\n";
        str = String.valueOf(str) + "Average Base Cost Per Card (Not Including 0 Cost): " + f.format((double)totalBaseCost / (double)totalCostCards) + "\n";
        str = String.valueOf(str) + "Cards by Base Cost:\n";
        str = String.valueOf(str) + this.printHash(baseCostHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        for (Hero h : this.lcmf.lcm.heroes) {
            str = String.valueOf(str) + h.analyseHero();
            str = String.valueOf(str) + "\n";
        }
        return str;
    }

    public void updateCount(HashMap<Object, Integer> hash, Object obj, int value) {
        Integer i = hash.get(obj);
        if (i == null) {
            i = new Integer(0);
        }
        i = new Integer(i + value);
        hash.put(obj, i);
    }

    public String printHash(HashMap<Object, Integer> hash, Integer total) {
        DecimalFormat f = new DecimalFormat("##.##");
        String str = "";
        Set<Map.Entry<Object, Integer>> set = new TreeMap<Object, Integer>(hash).entrySet();
        for (Map.Entry<Object, Integer> entry : set) {
            str = String.valueOf(str) + entry.getKey().toString() + ": " + entry.getValue();
            if (total != null) {
                str = String.valueOf(str) + " (" + f.format(CardMakerToolbar.getPercentageValue(entry.getValue(), total)) + "%)";
            }
            str = String.valueOf(str) + "\n";
        }
        return str;
    }

    public static double getPercentageValue(int value, int max) {
        return (double)value / (double)max * 100.0;
    }

    public CardMakerToolbar getCardMakerToolbar() {
        return tb;
    }

    public void setEditMenu() {
        String str = this.lcmf.tabs.getTitleAt(this.lcmf.tabs.getSelectedIndex());
        if (str.equals("Heroes")) {
            this.remove(1);
            this.add((Component)this.heroSelectorMenu, 1);
            return;
        }
        if (str.equals("Villains")) {
            this.remove(1);
            this.add((Component)this.villainSelectorMenu, 1);
            return;
        }
        if (str.equals("Schemes")) {
            this.remove(1);
            this.add((Component)this.schemeSelectorMenu, 1);
            return;
        }
        if (str.equals("Teams")) {
            this.remove(1);
            this.add((Component)this.teamSelectorMenu, 1);
            return;
        }
        if (str.equals("Bystanders")) {
            this.remove(1);
            this.add((Component)this.bystanderSelectorMenu, 1);
            return;
        }
        if (str.equals("Wounds")) {
            this.remove(1);
            this.add((Component)this.woundSelectorMenu, 1);
            return;
        }
        if (str.equals("Bindings")) {
            this.remove(1);
            this.add((Component)this.bindingsSelectorMenu, 1);
            return;
        }
        if (str.equals("Scheme Types")) {
            this.remove(1);
            this.add((Component)this.schemeTypeSelectorMenu, 1);
            return;
        }
        CustomTemplateList list = LegendaryCardMakerFrame.lcmf.customTemplateListSet.get(str);
        if (list != null) {
            this.remove(1);
            this.add((Component)list.menu, 1);
            return;
        }
    }

    public void removeEditMenus() {
        this.heroSelectorMenu.setVisible(false);
        this.villainSelectorMenu.setVisible(false);
        this.schemeSelectorMenu.setVisible(false);
        this.teamSelectorMenu.setVisible(false);
        this.bystanderSelectorMenu.setVisible(false);
        this.woundSelectorMenu.setVisible(false);
        this.bindingsSelectorMenu.setVisible(false);
        this.schemeTypeSelectorMenu.setVisible(false);
    }

    public void populateExpansionMenu() {
        String templateFolder = "legendary" + File.separator + "templates";
        File file = new File(templateFolder);
        if (file.exists()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    JCheckBoxMenuItem item = new JCheckBoxMenuItem(f.getName());
                    LegendaryCardMaker cfr_ignored_0 = this.lcmf.lcm;
                    if (f.getName().toLowerCase().equals(LegendaryCardMaker.expansionStyle.toLowerCase())) {
                        item.setSelected(true);
                    }
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String enumValue = ((JCheckBoxMenuItem)e.getSource()).getText().replace(" ", "_").toUpperCase();
                            for (JCheckBoxMenuItem item : CardMakerToolbar.tb.styleItems) {
                                if (item.getText().replace(" ", "_").toUpperCase().equals(enumValue)) {
                                    item.setSelected(true);
                                    LegendaryCardMaker cfr_ignored_0 = CardMakerToolbar.this.lcmf.lcm;
                                    LegendaryCardMaker.expansionStyle = item.getText();
                                    continue;
                                }
                                item.setSelected(false);
                            }
                        }
                    });
                    this.styleItems.add(item);
                    this.style.add(item);
                }
                ++n2;
            }
        }
    }

    private List<CardMaker> legendaryItemToCardMaker(List<LegendaryItem> items) {
        ArrayList<CardMaker> makers = new ArrayList<CardMaker>();
        for (LegendaryItem l : items) {
            int i;
            int count;
            if (l instanceof Hero) {
                Hero h = (Hero)l;
                for (HeroCard hc : h.cards) {
                    HeroMaker hm = new HeroMaker();
                    hm.setCard(hc);
                    count = hc.rarity.getCount();
                    if (hc.numberInDeck > 0) {
                        count = hc.numberInDeck;
                    }
                    i = 0;
                    while (i < count) {
                        makers.add(hm);
                        ++i;
                    }
                }
            }
            if (l instanceof Villain) {
                Villain v = (Villain)l;
                for (VillainCard vc : v.cards) {
                    VillainMaker vm = new VillainMaker();
                    vm.setCard(vc);
                    count = vc.cardType.getCount();
                    if (vc.numberInDeck > 0) {
                        count = vc.numberInDeck;
                    }
                    i = 0;
                    while (i < count) {
                        makers.add(vm);
                        ++i;
                    }
                }
            }
            if (l instanceof VillainCard) {
                VillainCard vc = (VillainCard)l;
                VillainMaker vm = new VillainMaker();
                vm.setCard(vc);
                int count2 = vc.cardType.getCount();
                if (vc.numberInDeck > 0) {
                    count2 = vc.numberInDeck;
                }
                int i2 = 0;
                while (i2 < count2) {
                    makers.add(vm);
                    ++i2;
                }
            }
            if (!(l instanceof SchemeCard)) continue;
            SchemeCard s = (SchemeCard)l;
            SchemeMaker sm = new SchemeMaker();
            sm.setCard(s);
            int i3 = 0;
            while (i3 < s.numberInDeck) {
                makers.add(sm);
                ++i3;
            }
        }
        return makers;
    }
}

